/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.jei;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.client.jei.JEIPlugin;
import mob_grinding_utils.recipe.SolidifyRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class SolidifierCategory
implements IRecipeCategory<SolidifyRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("mob_grinding_utils", "solidifier_jei");
    private final IDrawableStatic background;

    public SolidifierCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("mob_grinding_utils", "textures/gui/solidifier_jei.png"), 0, 0, 91, 26).setTextureSize(91, 26).build();
    }

    @Nonnull
    public RecipeType<SolidifyRecipe> getRecipeType() {
        return JEIPlugin.SOLIDIFY_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("mob_grinding_utiles.jei.solidifier");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ID;
    }

    @Nonnull
    public Class<? extends SolidifyRecipe> getRecipeClass() {
        return SolidifyRecipe.class;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SolidifyRecipe recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 5, 5).addIngredients(recipe.getMould());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 37, 5).addIngredients(VanillaTypes.FLUID, List.of(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), recipe.getFluidAmount())))).addTooltipCallback((recipeSlot, tooltip) -> {
            Optional ingredient = recipeSlot.getDisplayedIngredient(VanillaTypes.FLUID);
            ingredient.ifPresent(fluidStack -> {
                tooltip.add(new TextComponent(fluidStack.getAmount() + " mB"));
                tooltip.add(new TranslatableComponent("mob_grinding_utils.jei.any_experience").m_130940_(ChatFormatting.GRAY));
            });
        });
        builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 5).addItemStack(recipe.m_8043_());
    }
}

